/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.anvilmagma;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.anvilmagma.ContainerAnvilMagma;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.fluid.FluidMagmaHolder;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.ItemStackUtil;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileAnvilMagma
extends TileBlockEntityCyclic
implements MenuProvider {
    public static final int CAPACITY = 64000;
    public static ForgeConfigSpec.IntValue FLUIDCOST;
    ItemStackHandler inputSlots = new ItemStackHandler(1){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!stack.m_41619_() && stack.isRepairable() && stack.m_41773_() == 0) {
                return TileAnvilMagma.this.outputSlots.insertItem(slot, stack, simulate);
            }
            return super.insertItem(slot, stack, simulate);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.isRepairable() && stack.m_41773_() > 0;
        }
    };
    ItemStackHandler outputSlots = new ItemStackHandler(1);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    public FluidTankBase tank = new FluidTankBase(this, 64000, this.isFluidValid());
    LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);

    public TileAnvilMagma(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ANVIL_MAGMA.get(), pos, state);
        this.needsRedstone = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileAnvilMagma e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileAnvilMagma e) {
        e.tick();
    }

    public void tick() {
        boolean done;
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        ItemStack stack = this.inputSlots.getStackInSlot(0);
        if (stack.m_41619_() || stack.m_204117_(DataTags.ANVIL_IMMUNE)) {
            if (this.outputSlots.getStackInSlot(0).m_41619_()) {
                this.outputSlots.insertItem(0, stack.m_41777_(), false);
                this.inputSlots.extractItem(0, stack.m_41613_(), false);
            }
            return;
        }
        boolean bl = done = stack.m_41773_() == 0;
        if (done && this.outputSlots.getStackInSlot(0).m_41619_()) {
            this.outputSlots.insertItem(0, stack.m_41777_(), false);
            this.inputSlots.extractItem(0, stack.m_41613_(), false);
        }
        int repair = (Integer)FLUIDCOST.get();
        boolean work = false;
        if (this.tank != null && this.tank.getFluidAmount() >= repair && stack.isRepairable() && stack.m_41773_() > 0) {
            work = true;
            this.tank.drain(repair, IFluidHandler.FluidAction.EXECUTE);
        }
        if (work) {
            ItemStackUtil.repairItem(stack);
        }
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> {
            Fluid fluid = p.getFluid();
            return fluid == FluidMagmaHolder.STILL.get();
        };
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerAnvilMagma(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    static enum Fields {
        TIMER,
        REDSTONE;

    }
}

